/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.container;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.ContainerScreenFactory;
import net.fabricmc.fabric.api.client.screen.ScreenProviderRegistry;
import net.fabricmc.fabric.api.container.ContainerFactory;
import net.fabricmc.fabric.api.container.ContainerProviderRegistry;
import net.fabricmc.fabric.impl.container.ContainerProviderImpl;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ScreenProviderRegistryImpl
implements ScreenProviderRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScreenProviderRegistryImpl.class);
    private static final Map<class_2960, ContainerFactory<class_465>> FACTORIES = new HashMap<class_2960, ContainerFactory<class_465>>();

    @Override
    public void registerFactory(class_2960 identifier, ContainerFactory<class_465> factory) {
        if (FACTORIES.containsKey(identifier)) {
            throw new RuntimeException("A factory has already been registered as " + String.valueOf(identifier) + "!");
        }
        FACTORIES.put(identifier, factory);
    }

    @Override
    public <C extends class_1703> void registerFactory(class_2960 identifier, ContainerScreenFactory<C> containerScreenFactory) {
        this.registerFactory(identifier, (int syncId, class_2960 identifier1, class_1657 player, class_2540 buf) -> {
            Object container = ((ContainerProviderImpl)ContainerProviderRegistry.INSTANCE).createContainer(syncId, identifier1, player, buf);
            if (container == null) {
                LOGGER.error("Could not open container for {} - a null object was created!", (Object)identifier1.toString());
                return null;
            }
            return containerScreenFactory.create(container);
        });
    }

    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ContainerProviderImpl.OPEN_CONTAINER, (client, handler, buf, responseSender) -> {
            class_2960 identifier = buf.method_10810();
            short syncId = buf.readUnsignedByte();
            buf.retain();
            client.execute(() -> {
                try {
                    ContainerFactory<class_465> factory = FACTORIES.get(identifier);
                    if (factory == null) {
                        LOGGER.error("No GUI factory found for {}!", (Object)identifier.toString());
                        return;
                    }
                    class_746 player = client.field_1724;
                    class_465 gui = factory.create(syncId, identifier, (class_1657)player, buf);
                    player.field_7512 = gui.method_17577();
                    client.method_1507((class_437)gui);
                }
                finally {
                    buf.release();
                }
            });
        });
    }
}

